#! /usr/bin/env julia
#
# setup-environment.jl
# ---------------------------------------------------------


# ---------------------------------------------------------
import Pkg

Pkg.add("Compat")
Pkg.add("CSV")
Pkg.add("DataFrames")
Pkg.add("Dates")
Pkg.add("Distributed")
Pkg.add("FileIO")
Pkg.add("JLD2")
Pkg.add("LaTeXStrings")
Pkg.add("Logging")
Pkg.add("LoggingExtras")
Pkg.add("ParallelDataTransfer")
Pkg.add("Parameters")
Pkg.add("PGFPlotsX")
Pkg.add("Plots")
Pkg.add("Printf")
Pkg.add("ProgressMeter")
Pkg.add("Random")
Pkg.add("SortingAlgorithms")
Pkg.add("Statistics")
# ---------------------------------------------------------


# ---------------------------------------------------------
# logging
run(`mkdir -p log`)
using Logging, LoggingExtras, Dates

# clean up the files
map(x->rm(x, force=true), ["./log/setup_info.log.jl", "./log/setup_warn.log.jl", "./log/setup_full.log.jl"]);
# custom timestamps
const log_date_format = "yyyy-mm-dd HH:MM:SS"
timestamp_logger(logger) = TransformerLogger(logger) do log
  merge(log, (; message = "$(Dates.format(now(), log_date_format)) \n$(log.message)"))
end
# custom filter: remove message that match some packages for example
function not_StatsModels_message_filter(log)
    log._module != StatsModels
end
# create the debugger
demux_logger = TeeLogger(
    MinLevelLogger(FileLogger("./log/setup_info.log.jl"), Logging.Info),
    MinLevelLogger(FileLogger("./log/setup_warn.log.jl"), Logging.Warn),
    MinLevelLogger(FileLogger("./log/setup_full.log.jl"), Logging.Debug),
    ConsoleLogger(stdout, Logging.Info),   # Common logger to be able to see info and warning in repl
) |> timestamp_logger |> global_logger;
# ---------------------------------------------------------


# ---------------------------------------------------------
push!(LOAD_PATH, "./src")
using project_routines
# ---------------------------------------------------------

